(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5609,        203]*)
(*NotebookOutlinePosition[      6453,        230]*)
(*  CellTagsIndexPosition[      6409,        226]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \( (*\ Example\ 2.1 \( \(.3\)\(.\)\)\ *) \(k[x_, 
          n_] := \ \((x\  - \((x^\((n + 2)\))\)/\((n + 2)\))\)/\((n + 
              1)\);\)\), "\n", 
    \(k[x, 1]\ \n (*\ this\ is\ w1[x]\ *) \)}], "Input"],

Cell[BoxData[
    \(1\/2\ \((x - x\^3\/3)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\((1/2)\)*\ \((k[x, 1] - k[x, 3]/3)\) // Expand\  (*\ 
      This\ is\ w2[x]\ *) \)\)], "Input"],

Cell[BoxData[
    \(\(5\ x\)\/24 - x\^3\/12 + x\^5\/120\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\((5/24)\)*k[x, 1] - \ k[x, 3]/12 + k[x, 5]/120 // Expand\n (*\ 
      This\ is\ w3[x]\ *) \)\)], "Input"],

Cell[BoxData[
    \(\(61\ x\)\/720 - \(5\ x\^3\)\/144 + x\^5\/240 - x\^7\/5040\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(61\ *\ k[x, 1]/720 - 5*k[x, 3]/144 + k[x, 5]/240 - k[x, 7]/5040 // 
      Expand\n (*\ This\ is\ w4[x]\ *) \)\)], "Input"],

Cell[BoxData[
    \(\(277\ x\)\/8064 - \(61\ x\^3\)\/4320 + x\^5\/576 - x\^7\/10080 + 
      x\^9\/362880\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(277\ *k[x, 1]/8064\  - \ 61\ *\ k[x, 3]/4320\  + k[x, 5]/576\  - 
        k[x, 7]/10080\  + \ k[x, 9]/362880 // Expand\n (*\ 
      This\ is\ w5[x]\ *) \)\)], "Input"],

Cell[BoxData[
    \(\(50521\ x\)\/3628800 - \(277\ x\^3\)\/48384 + \(61\ x\^5\)\/86400 - 
      x\^7\/24192 + x\^9\/725760 - x\^11\/39916800\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ Collecting\ all\ five\ functions\ w[x]\ *) \n
    w1[x_] := 1\/2\ \((x - x\^3\/3)\); \n
    w2[x_] := \ \(5\ x\)\/24 - x\^3\/12 + x\^5\/120; \n
    w3[x_] := \ \(61\ x\)\/720 - \(5\ x\^3\)\/144 + x\^5\/240 - x\^7\/5040; \n
    w4[x_] := \ 
      \(277\ x\)\/8064 - \(61\ x\^3\)\/4320 + x\^5\/576 - x\^7\/10080 + 
        x\^9\/362880; \n
    w5[x_] := \ 
      \(50521\ x\)\/3628800 - \(277\ x\^3\)\/48384 + \(61\ x\^5\)\/86400 - 
        x\^7\/24192 + x\^9\/725760 - x\^11\/39916800; \n
    normw1 = Sqrt[NIntegrate[\((w1[x])\)^2, \ {x, \ 0, \ 1}]]\)\)], "Input"],

Cell[BoxData[
    \(0.232310684145723245`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(normw2 = Sqrt[NIntegrate[\((w2[x])\)^2, \ {x, \ 0, \ 1}]]\)], "Input"],

Cell[BoxData[
    \(0.0941447583772044183`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(normw3 = Sqrt[NIntegrate[\((w3[x])\)^2, \ {x, \ 0, \ 1}]]\)], "Input"],

Cell[BoxData[
    \(0.038155397875678334`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(normw4 = Sqrt[NIntegrate[\((w4[x])\)^2, \ {x, \ 0, \ 1}]]\)], "Input"],

Cell[BoxData[
    \(0.0154638001229824624`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(normw5 = Sqrt[NIntegrate[\((w5[x])\)^2, \ {x, \ 0, \ 1}]]\)], "Input"],

Cell[BoxData[
    \(0.00626724212738879593`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(lam1 = normw1/normw2\)], "Input"],

Cell[BoxData[
    \(2.46759021054509819`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(lam2 = normw2/normw3\)], "Input"],

Cell[BoxData[
    \(2.46740339817595755`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\( (*\ 
      Note\ that\ lam1\ and\ lam2\ are\ the\ values\ of\ \[Lambda]1\ computed
          \ from\ \((2.1  .19)\)\ for\ \n\t\tn = \(2\ and\ n = 3\)\ *) \n (*\ 
      Now\ we\ shall\ use\ \((2.1  .20)\)\ to\ compute\ \[Lambda]1\ for\ n = 
        \(2\ and\ n = 3\), \ respectively, \ calling\ them\ la1\ and\ la2\ *) 
      \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(la1 = 1/Sqrt[normw2]\)], "Input"],

Cell[BoxData[
    \(3.25913182729742167`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(la2 = 1/\((normw3)\)^\((1/3)\)\)], "Input"],

Cell[BoxData[
    \(2.9703981868435294`\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{79, Automatic}, {Automatic, 34}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 228, 4, 75, "Input"],
Cell[1970, 57, 57, 1, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2064, 63, 118, 2, 27, "Input"],
Cell[2185, 67, 69, 1, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2291, 73, 128, 2, 43, "Input"],
Cell[2422, 77, 92, 1, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2551, 83, 144, 2, 59, "Input"],
Cell[2698, 87, 119, 2, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2854, 94, 189, 3, 59, "Input"],
Cell[3046, 99, 154, 2, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3237, 106, 591, 11, 267, "Input"],
Cell[3831, 119, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3923, 125, 90, 1, 27, "Input"],
Cell[4016, 128, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4109, 134, 90, 1, 27, "Input"],
Cell[4202, 137, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4294, 143, 90, 1, 27, "Input"],
Cell[4387, 146, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4480, 152, 90, 1, 27, "Input"],
Cell[4573, 155, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4667, 161, 53, 1, 27, "Input"],
Cell[4723, 164, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4814, 170, 53, 1, 27, "Input"],
Cell[4870, 173, 54, 1, 26, "Output"]
}, Open  ]],
Cell[4939, 177, 363, 6, 107, "Input"],

Cell[CellGroupData[{
Cell[5327, 187, 53, 1, 27, "Input"],
Cell[5383, 190, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5474, 196, 63, 1, 27, "Input"],
Cell[5540, 199, 53, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

